import time
import subprocess
import sys

# --- glibc rand implementation ---
class CRand:
    def __init__(self, seed):
        self.state = seed & 0x7fffffff

    def rand(self):
        self.state = (1103515245 * self.state + 12345) & 0x7fffffff
        return self.state

def gen_password(seed):
    r = CRand(seed)
    pw = ""
    for _ in range(20):
        pw += chr(ord('a') + (r.rand() % 26))
    return pw

# --- launch the vulnerable binary ---
p = subprocess.Popen(
    ["./guess_password_easy.c"],   # <-- change binary name if needed
    stdin=subprocess.PIPE,
    stdout=subprocess.PIPE,
    stderr=subprocess.PIPE,
    text=True
)

# read first leak
line = p.stdout.readline().strip()
print("[+] Leak:", line)

leak = line.split(" ")[2][:5]
print("[+] Leaked prefix:", leak)

now = int(time.time())

# brute-force seed window
for seed in range(now - 10, now + 2):
    pw = gen_password(seed)
    if pw.startswith(leak):
        print("[+] Seed found:", seed)
        print("[+] Password:", pw)

        # send password
        p.stdin.write(pw + "\n")
        p.stdin.flush()

        # print remaining output (flag)
        print(p.stdout.read())
        break
else:
    print("[-] Seed not found, expand time window")
